<?php

class AVForums_Competitions_ControllerPublic_Thread extends XFCP_AVForums_Competitions_ControllerPublic_Thread
{
	public function actionIndex()
	{
		$parent = parent::actionIndex();

		if (!empty($parent->params['thread']))
		{
			$thread = $parent->params['thread'];

			if (!empty($thread['discussion_type'])
				&& $thread['discussion_type'] == 'competition'
			)
			{
				$competitionModel = $this->_getCompetitionModel();

				$competition = $competitionModel->getCompetitionByThreadId($thread['thread_id']);
				if (!$competition)
				{
					return $parent;
				}
				$competition = $competitionModel->prepareCompetition($competition);

				$parent->params['competition'] = $competition;
				$parent->params['selectedTab'] = 'discussion';
			}
		}

		return $parent;
	}

	/**
	 * @return AVForums_Competitions_Model_Competition
	 */
	protected function _getCompetitionModel()
	{
		return $this->getModelFromCache('AVForums_Competitions_Model_Competition');
	}
}